/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UIStyleBean;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.settings.user.DefaultUserSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class UserSettingsTasklet
extends PanelTasklet {
    private static final String TRACE_MASKT = "HUSTM  T";
    private static final String TRACE_MASKF = "HUSTM  F";
    private static final String TRACE_MASKD = "HUSTM  D";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.settings.user.res.UserSettingsRes";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.base.settings.user.UserSettings";
    private String settingsClassName;

    public UserSettingsTasklet() {
        this(null);
    }

    public UserSettingsTasklet(String settingsClassName) {
        this.settingsClassName = settingsClassName;
        Trace.trace(TRACE_MASKT, "<> UserSettingsTasklet.UserSettingsTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UserSettingsTasklet.service()");
        try {
            if (request.isInitialRequest()) {
                this.serviceInitialRequest(request, response);
            } else if (request.isDisposed() || request.isCanceled()) {
                Trace.trace(TRACE_MASKF, "   terminating the tasklet");
                response.terminate();
            } else {
                String requestType = (String)request.getData("RequestType");
                if (requestType == null) {
                    Trace.trace(TRACE_MASKF, "   requestType is null, terminating the tasklet");
                    response.terminate();
                }
                if (requestType.equals("UpdateSettings")) {
                    this.serviceUpdateSettings(request, response);
                } else if (requestType.equals("GetDefaults")) {
                    this.serviceGetDefaultSettings(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "   unknown requestType, terminating the tasklet");
                    response.terminate();
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "   exception during service: " + exc);
            if (exc instanceof TaskletException) {
                throw (TaskletException)exc;
            }
            throw new TaskletException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- UserSettingsTasklet.service()");
    }

    protected void serviceInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UserSettingsTasklet.serviceInitialRequest()");
        Map userSettings = User.getUser().getAllUserSettings();
        Collection collection = userSettings.values();
        UserSettings userSettingsObject = null;
        ArrayList<UserSettings> list = new ArrayList<UserSettings>();
        int i = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            userSettingsObject = (UserSettings)iterator.next();
            if (userSettingsObject.getTaskletClassName() != null) {
                list.add(userSettingsObject);
            }
            ++i;
        }
        Collections.sort(list, new MyComparator());
        Properties help = new Properties();
        i = 0;
        while (i < list.size()) {
            UserSettings next = (UserSettings)list.get(i);
            help.put(next.getHelpPanelId(), next.getHelpPanelProperties());
            ++i;
        }
        DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData(AUIML_FILE_NAME, "UserSettingsFramePanel", new UIStyleBean(), null, new String("UST" + this.taskletId), null, help);
        DisplayAreaDescriptorDelegate[] delegate = new DisplayAreaDescriptorDelegate[list.size()];
        i = 0;
        while (i < list.size()) {
            UserSettings next = (UserSettings)list.get(i);
            String className = next.getTaskletClassName();
            Trace.trace(TRACE_MASKF, "   next tasklet name is " + className);
            delegate[i] = new DisplayAreaDescriptorDelegate(className, null);
            delegate[i].setMountPoint("MountPointTPane");
            ++i;
        }
        DisplayAreaDescriptor[] descriptors = new DisplayAreaDescriptor[delegate.length];
        i = 0;
        while (i < descriptors.length) {
            descriptors[i] = delegate[i];
            ++i;
        }
        response.replace(frame, descriptors);
        Trace.trace(TRACE_MASKF, "<- UserSettingsTasklet.serviceInitialRequest()");
    }

    protected void serviceUpdateSettings(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UserSettingsTasklet.serviceUpdateSettings()");
        User.getUser().setUserSettings((UserSettings)request.getData("UpdateSettings"));
        response.noAction();
        Trace.trace(TRACE_MASKF, "<- UserSettingsTasklet.serviceUpdateSettings()");
    }

    protected void serviceGetDefaultSettings(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UserSettingsTasklet.serviceGetDefaultSettings()");
        if (this.settingsClassName == null) {
            throw new TaskletException("'settingsClassName' is null");
        }
        UserSettings settings = DefaultUserSettings.getDefaultUserSettings().getUserSettings(this.settingsClassName);
        response.update(this.settingsClassName, settings);
        Trace.trace(TRACE_MASKF, "<- UserSettingsTasklet.serviceGetDefaultSettings()");
    }

    public void logException(Throwable thr) {
        thr.printStackTrace();
    }

    class MyComparator
    implements Comparator {
        MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.getClass().getName();
            String s2 = o2.getClass().getName();
            return s1.compareTo(s2);
        }

        public boolean equals(Object o) {
            return false;
        }
    }
}

